
//Chris' WinGlide enhancements
//Copr. 1998, 1999 Chris Dohnal (cwdohnal@ucdavis.edu)

#include <windows.h>

#define FX_GLIDE_NO_FUNC_PROTO
#include <glide.h>
#include <glideutl.h>
#include "msgbox.h"
#include "inifile.h"

#define IMPORTS_C
#include "pointers.h"
#undef IMPORTS_C

CONST char GLIDE3X_DLL[] = "\\glide3x.dll";

HINSTANCE LoadGlideSymbols(HINSTANCE);
BOOL LoadFunction(HANDLE, const LPVOID, LPCSTR, LPCSTR);

#define LOADFUNC(name, parmsize) \
	if (LoadFunction(hGlide, &(_##name), #name, #parmsize) == FALSE) { \
		return NULL; \
	}


//Return the handle of the original glide3x.dll on success or NULL on failure
HINSTANCE LoadGlideSymbols(HINSTANCE hDllInst) {
	//Easier to use MAX_PATH * 2 instead of checking string lengths
	char szGlide3x[MAX_PATH + 1 + MAX_PATH + 1];
	HINSTANCE hGlide;

	GetSystemDirectory(szGlide3x, sizeof(szGlide3x) - 1);
	lstrcat(szGlide3x, "\\");
	lstrcat(szGlide3x, gszGlide3xName);
	hGlide = LoadLibrary(szGlide3x);

	if ((hGlide == NULL) || (hGlide == hDllInst)) {
		//Use szGlide3x as a buffer for the error message
		lstrcpy(szGlide3x, gszGlide3xName);
		lstrcat(szGlide3x, " not found in system directory.");
		ErrorLoadingWinGlideMessageBox(NULL, szGlide3x);

		return NULL;
	}

	LOADFUNC(grDrawPoint, 4);
	LOADFUNC(grDrawLine, 8);
	LOADFUNC(grDrawTriangle, 12);
	LOADFUNC(grVertexLayout, 12);
	LOADFUNC(grDrawVertexArray, 12);
	LOADFUNC(grDrawVertexArrayContiguous, 16);
	LOADFUNC(grAADrawTriangle, 24);
	LOADFUNC(grBufferClear, 12);
	LOADFUNC(grBufferSwap, 4);
	LOADFUNC(grRenderBuffer, 4);
	LOADFUNC(grErrorSetCallback, 4);
	LOADFUNC(grFinish, 0);
	LOADFUNC(grFlush, 0);
	LOADFUNC(grSstWinOpen, 28);
	LOADFUNC(grSstWinClose, 4);
	LOADFUNC(grSelectContext, 4);
	LOADFUNC(grSstOrigin, 4);
	LOADFUNC(grSstSelect, 4);
	LOADFUNC(grAlphaBlendFunction, 16);
	LOADFUNC(grAlphaCombine, 20);
	LOADFUNC(grAlphaControlsITRGBLighting, 4);
	LOADFUNC(grAlphaTestFunction, 4);
	LOADFUNC(grAlphaTestReferenceValue, 4);
	LOADFUNC(grChromakeyMode, 4);
	LOADFUNC(grChromakeyValue, 4);
	LOADFUNC(grClipWindow, 16);
	LOADFUNC(grColorCombine, 20);
	LOADFUNC(grColorMask, 8);
	LOADFUNC(grCullMode, 4);
	LOADFUNC(grConstantColorValue, 4);
	LOADFUNC(grDepthBiasLevel, 4);
	LOADFUNC(grDepthBufferFunction, 4);
	LOADFUNC(grDepthBufferMode, 4);
	LOADFUNC(grDepthMask, 4);
	LOADFUNC(grDisableAllEffects, 0);
	LOADFUNC(grDitherMode, 4);
	LOADFUNC(grFogColorValue, 4);
	LOADFUNC(grFogMode, 4);
	LOADFUNC(grFogTable, 4);
	LOADFUNC(grLoadGammaTable, 16);
	LOADFUNC(grSplash, 20);
	LOADFUNC(grGet, 12);
	LOADFUNC(grGetString, 4);
	LOADFUNC(grQueryResolutions, 8);
	LOADFUNC(grReset, 4);
	LOADFUNC(grGetProcAddress, 4);
	LOADFUNC(grEnable, 4);
	LOADFUNC(grDisable, 4);
	LOADFUNC(grCoordinateSpace, 4);
	LOADFUNC(grDepthRange, 8);
	LOADFUNC(grViewport, 16);
	LOADFUNC(grTexCalcMemRequired, 16);
	LOADFUNC(grTexTextureMemRequired, 8);
	LOADFUNC(grTexMinAddress, 4);
	LOADFUNC(grTexMaxAddress, 4);
	LOADFUNC(grTexNCCTable, 4);
	LOADFUNC(grTexSource, 16);
	LOADFUNC(grTexClampMode, 12);
	LOADFUNC(grTexCombine, 28);
	LOADFUNC(grTexDetailControl, 16);
	LOADFUNC(grTexFilterMode, 12);
	LOADFUNC(grTexLodBiasValue, 8);
	LOADFUNC(grTexDownloadMipMap, 16);
	LOADFUNC(grTexDownloadMipMapLevel, 32);
	LOADFUNC(grTexDownloadMipMapLevelPartial, 40);
	LOADFUNC(grTexDownloadTable, 8);
	LOADFUNC(grTexDownloadTablePartial, 16);
	LOADFUNC(grTexMipMapMode, 12);
	LOADFUNC(grTexMultibase, 8);
	LOADFUNC(grTexMultibaseAddress, 20);
	LOADFUNC(grLfbLock, 24);
	LOADFUNC(grLfbUnlock, 8);
	LOADFUNC(grLfbConstantAlpha, 4);
	LOADFUNC(grLfbConstantDepth, 4);
	LOADFUNC(grLfbWriteColorSwizzle, 8);
	LOADFUNC(grLfbWriteColorFormat, 4);
	LOADFUNC(grLfbWriteRegion, 36);
	LOADFUNC(grLfbReadRegion, 28);
	LOADFUNC(grGlideInit, 0);
	LOADFUNC(grGlideShutdown, 0);
	LOADFUNC(grGlideGetState, 4);
	LOADFUNC(grGlideSetState, 4);
	LOADFUNC(grGlideGetVertexLayout, 4);
	LOADFUNC(grGlideSetVertexLayout, 4);

	LOADFUNC(guGammaCorrectionRGB, 12);
	LOADFUNC(guFogTableIndexToW, 4);
	LOADFUNC(guFogGenerateExp, 8);
	LOADFUNC(guFogGenerateExp2, 8);
	LOADFUNC(guFogGenerateLinear, 12);
	LOADFUNC(gu3dfGetInfo, 8);
	LOADFUNC(gu3dfLoad, 8);

	return hGlide;
}

BOOL LoadFunction(HANDLE hGlide, LPVOID *ppFunction, LPCSTR pName, LPCSTR pParamSize) {
	#define MAX_NAME_LEN	64
	char szName[MAX_NAME_LEN];
	char szBuffer[MAX_NAME_LEN + 64];

	//Construct the name of the function to load
	lstrcpy(szName, "_");
	lstrcat(szName, pName);
	lstrcat(szName, "@");
	lstrcat(szName, pParamSize);

	//Get the function address
	*ppFunction = GetProcAddress(hGlide, szName);
	if (*ppFunction == NULL) {
		//Free the Glide library
		FreeLibrary(hGlide);
		
		//Display an error message
		lstrcpy(szBuffer, "Error loading symbol ");
		lstrcat(szBuffer, pName);
		lstrcat(szBuffer, " from glide3x.dll");
		ErrorLoadingWinGlideMessageBox(NULL, szBuffer);
		
		return FALSE;
	}

	return TRUE;
}
